<?php

return array(
	'title'    => esc_html( __( 'Translation String', 'jnews-front-translation' ) ),
	'name'     => 'translation',
	'icon'     => 'font-awesome:fa-pencil',
	'controls' => array(

		array(
			'type'   => 'section',
			'title'  => 'General',
			'name'   => 'general_section',
			'fields' => array(

				array(
					'type'    => 'textbox',
					'name'    => 'home',
					'label'   => 'Home',
					'default' => 'Home'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'author',
					'label'   => 'Author',
					'default' => 'Author'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'search',
					'label'   => 'Search',
					'default' => 'Search'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'category',
					'label'   => 'Category',
					'default' => 'Category'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'tag',
					'label'   => 'Tag',
					'default' => 'Tag'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'of',
					'label'   => 'Of',
					'default' => 'of'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'views',
					'label'   => 'VIEWS',
					'default' => 'VIEWS'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'shares_uppercase',
					'label'   => 'SHARES',
					'default' => 'SHARES'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'page_not_found',
					'label'   => 'Page Not Found',
					'default' => 'Page Not Found'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'back_to_top',
					'label'   => 'Back to top',
					'default' => 'Back to top'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'sorry_page_not_found',
					'label'   => 'Sorry Page Not Found',
					'default' => 'Sorry the page you were looking for cannot be found. Try searching for the best match or browse the links below:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'all',
					'label'   => 'All',
					'default' => 'All'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'reviews',
					'label'   => 'Reviews',
					'default' => 'Reviews'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'by',
					'label'   => 'By',
					'default' => 'by'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'others',
					'label'   => 'Others',
					'default' => 'others'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'and',
					'label'   => 'And',
					'default' => 'and'
				),
				array(
					'type'    => 'textbox',
					'name'    => ',',
					'label'   => ', ( Comma )',
					'default' => ','
				),
				array(
					'type'    => 'textbox',
					'name'    => 'in',
					'label'   => 'In',
					'default' => 'in'
				),


				array(
					'type'    => 'textbox',
					'name'    => 'load_more',
					'label'   => 'Load More',
					'default' => 'Load More'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'end_of_content',
					'label'   => 'End of Content',
					'default' => 'End of Content'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'loading',
					'label'   => 'Loading...',
					'default' => 'Loading...'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'close_menu',
					'label'   => 'Close Menu',
					'default' => 'Close Menu'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'cart',
					'label'   => 'Cart',
					'default' => 'Cart'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'next_post',
					'label'   => 'Next Post',
					'default' => 'Next Post'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'previous_post',
					'label'   => 'Previous Post',
					'default' => 'Previous Post'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'read_more',
					'label'   => 'Read more',
					'default' => 'Read more'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'show_more_contributor',
					'label'   => 'Show More Contributor',
					'default' => 'Show More Contributor'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'previous',
					'label'   => 'Previous',
					'default' => 'Previous'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'prev',
					'label'   => 'Prev',
					'default' => 'Prev'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'next',
					'label'   => 'Next',
					'default' => 'Next'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'search_result_for_s',
					'label'   => 'Search Result for %s',
					'default' => "Search Result for '%s'"
				),
				array(
					'type'    => 'textbox',
					'name'    => 'search_form',
					'label'   => 'Search...',
					'default' => "Search..."
				),
				array(
					'type'    => 'textbox',
					'name'    => 'no_result',
					'label'   => 'No Result',
					'default' => "No Result"
				),
				array(
					'type'    => 'textbox',
					'name'    => 'view_all_result',
					'label'   => 'View All Result',
					'default' => "View All Result"
				),
				array(
					'type'    => 'textbox',
					'name'    => 'ago',
					'label'   => 'Ago',
					'default' => 'ago'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'sago',
					'label'   => '%s Ago',
					'default' => '%s ago'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login',
					'label'   => 'Login',
					'default' => 'Login'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'account',
					'label'   => 'Account',
					'default' => 'Account'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'logout',
					'label'   => 'Logout',
					'default' => 'Logout'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register',
					'label'   => 'Register',
					'default' => 'Register'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'order_list',
					'label'   => 'Order List',
					'default' => 'Order List'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'edit_profile',
					'label'   => 'Edit Profile',
					'default' => 'Edit Profile'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'latest_articles',
					'label'   => 'Latest Articles',
					'default' => 'Latest Articles'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'optimal_column',
					'label'   => 'Optimal Column',
					'default' => 'Optimal Column'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'no_content_available',
					'label'   => 'No Content Available',
					'default' => 'No Content Available'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'page_s_of_s',
					'label'   => 'Page %s of %s',
					'default' => 'Page %s of %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'page_s',
					'label'   => 'Page %s',
					'default' => 'Page %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'currently_playing',
					'label'   => 'Currently Playing',
					'default' => 'Currently Playing'
				),


				array(
					'type'    => 'textbox',
					'name'    => 'latest',
					'label'   => 'Latest',
					'default' => 'Latest'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'trending',
					'label'   => 'Trending',
					'default' => 'Trending'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'filter',
					'label'   => 'Filter',
					'default' => 'Filter'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'tags',
					'label'   => 'Tags:',
					'default' => 'Tags:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'related',
					'label'   => 'Related',
					'default' => 'Related'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'related_content',
					'label'   => 'Related Content',
					'default' => 'Related Content'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'continue_reading',
					'label'   => 'Continue Reading',
					'default' => 'Continue Reading'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'posts',
					'label'   => 'Posts',
					'default' => ' Posts'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'shares',
					'label'   => 'shares',
					'default' => 'shares'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'share',
					'label'   => 'Share',
					'default' => 'Share'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'send',
					'label'   => 'Send',
					'default' => 'Send'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'scan',
					'label'   => 'Scan',
					'default' => 'Scan'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'tweet',
					'label'   => 'Tweet',
					'default' => 'Tweet'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'bookmark',
					'label'   => 'Bookmark',
					'default' => 'Bookmark'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'pin',
					'label'   => 'Pin',
					'default' => 'Pin'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'fan',
					'label'   => 'Fan',
					'default' => 'Fan'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'fans',
					'label'   => 'Fans',
					'default' => 'Fans'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'follower',
					'label'   => 'Follower',
					'default' => 'Follower'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'followers',
					'label'   => 'Followers',
					'default' => 'Followers'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'subscriber',
					'label'   => 'Subscriber',
					'default' => 'Subscriber'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'subscribers',
					'label'   => 'Subscribers',
					'default' => 'Subscribers'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'close_esc',
					'label'   => 'Close (Esc)',
					'default' => 'Close (Esc)'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'toggle_fullscreen',
					'label'   => 'Toggle fullscreen',
					'default' => 'Toggle fullscreen'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'zoom_in_out',
					'label'   => 'Zoom in/out',
					'default' => 'Zoom in/out'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'zoom_reset',
					'label'   => 'Zoom Reset',
					'default' => 'Reset'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'previous_arrow_left',
					'label'   => 'Previous (arrow left)',
					'default' => 'Previous (arrow left)'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'next_arrow_right',
					'label'   => 'Next (arrow right)',
					'default' => 'Next (arrow right)'
				),


				array(
					'type'    => 'textbox',
					'name'    => 'jump_to_section',
					'label'   => 'Jump to section',
					'default' => 'Jump to section'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'comments',
					'label'   => 'Comments',
					'default' => 'Comments'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'edit_comment',
					'label'   => '(Edit)',
					'default' => '(Edit)'
				),
				array(
					'type'    => 'textarea',
					'name'    => 'please_login_join_discussion',
					'label'   => 'Please login to join discussion',
					'default' => 'Please <a href=\'%s\' class=\'%s\'>login</a> to join discussion'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'discussion_about_this',
					'label'   => 'Discussion about this %s',
					'default' => 'Discussion about this %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'comment_moderation',
					'label'   => 'Your comment is awaiting moderation',
					'default' => 'Your comment is awaiting moderation'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'read-comment',
					'label'   => 'Read All Comment',
					'default' => 'Read All Comment'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'leave-comment',
					'label'   => 'Leave Comment',
					'default' => 'Leave Comment'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'loading-comment',
					'label'   => 'Loading Comment',
					'default' => 'Loading Comment'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'advertisement',
					'label'   => 'Advertisement',
					'default' => 'ADVERTISEMENT'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'view_shopping_cart',
					'label'   => 'View your shopping cart',
					'default' => 'View your shopping cart'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'reading_time',
					'label'   => 'Reading Time:',
					'default' => 'Reading Time:'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'min_read',
					'label'   => 'Min Read',
					'default' => 'min read'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'source_text',
					'label'   => 'Source Label',
					'default' => 'Source:'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'via_text',
					'label'   => 'Via Label',
					'default' => 'Via:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'updated_on',
					'label'   => 'Updated On',
					'default' => 'Updated On'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'JNews Review',
			'name'   => 'review_section',
			'fields' => array(


				array(
					'type'    => 'textbox',
					'name'    => 'review_breakdown',
					'label'   => 'Review Breakdown',
					'default' => 'Review Breakdown'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'score',
					'label'   => 'Score',
					'default' => 'Score'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'pros',
					'label'   => 'PROS',
					'default' => 'PROS'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'cons',
					'label'   => 'CONS',
					'default' => 'CONS'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'view',
					'label'   => 'VIEW',
					'default' => 'VIEW'
				),
				array(
					'type'    => 'textbox',
					'name'    => 's_DEALS',
					'label'   => '%s DEALS',
					'default' => '%s DEALS'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'best_price_available',
					'label'   => 'We collect information from many stores for best price available',
					'default' => 'We collect information from many stores for best price available'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'best_price',
					'label'   => 'Best Price',
					'default' => 'Best Price'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'the_review',
					'label'   => 'The Review',
					'default' => 'The Review'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'avg_score',
					'label'   => 'Average Score',
					'default' => 'Average Score'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'buy_now',
					'label'   => 'Buy Now',
					'default' => 'Buy Now'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'available_at',
					'label'   => 'Available at',
					'default' => 'Available at'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'search_review',
					'label'   => 'Search Review...',
					'default' => 'Search Review...'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'no_review',
					'label'   => 'No review found',
					'default' => 'No review found'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'all_category',
					'label'   => 'All Category',
					'default' => 'All Category'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'newest_first',
					'label'   => 'Newest First',
					'default' => 'Newest First'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'oldest_first',
					'label'   => 'Oldest First',
					'default' => 'Oldest First'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'highest_price',
					'label'   => 'Highest Price',
					'default' => 'Highest Price'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'lowest_price',
					'label'   => 'Lowest Price',
					'default' => 'Lowest Price'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'highest_rating',
					'label'   => 'Highest Rating',
					'default' => 'Highest Rating'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'lowest_rating',
					'label'   => 'Lowest Rating',
					'default' => 'Lowest Rating'
				),

			)
		),


		array(
			'type'   => 'section',
			'title'  => 'JNews Food Recipe',
			'name'   => 'food_recipe_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'ingredients',
					'label'   => 'Ingredients',
					'default' => 'Ingredients'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'instructions',
					'label'   => 'Instructions',
					'default' => 'Instructions'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'serves',
					'label'   => 'Serve Size',
					'default' => 'Serves:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'cook_time',
					'label'   => 'Cook Time',
					'default' => 'Cook time: %s minutes'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'level',
					'label'   => 'Cook Level',
					'default' => 'Level:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'print_recipe',
					'label'   => 'Print Recipe Button Text',
					'default' => 'Print Recipe'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'JNews Like',
			'name'   => 'like_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'liked_post',
					'label'   => 'Liked Post',
					'default' => 'Liked Post'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'disliked_post',
					'label'   => 'Disliked Post',
					'default' => 'Disliked Post'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'must_login',
					'label'   => 'You must login to vote!',
					'default' => 'You must login to vote!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'thanks_for_your_vote',
					'label'   => 'Thanks for your vote!',
					'default' => 'Thanks for your vote!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'internal_db_error',
					'label'   => 'Internal DB Error!',
					'default' => 'Internal DB Error!'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'JNews Push Notification',
			'name'   => 'push_notification_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'push_notification_subscribe',
					'label'   => 'Subscribe Button Text',
					'default' => 'Subscribe'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'push_notification_unsubscribe',
					'label'   => 'Unsubscribe Button Text',
					'default' => 'Unsubscribe'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'push_notification_processing',
					'label'   => 'Processing Button Text',
					'default' => 'Processing . . .'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'Social media',
			'name'   => 'social_media_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'facebook',
					'label'   => 'Facebook',
					'default' => 'Facebook'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'twitter',
					'label'   => 'Twitter',
					'default' => 'Twitter'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'linkedin',
					'label'   => 'LinkedIn',
					'default' => 'LinkedIn'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'google',
					'label'   => 'Google+',
					'default' => 'Google+'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'pinterest',
					'label'   => 'Pinterest',
					'default' => 'Pinterest'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'behance',
					'label'   => 'Behance',
					'default' => 'Behance'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'github',
					'label'   => 'Github',
					'default' => 'Github'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'flickr',
					'label'   => 'Flickr',
					'default' => 'Flickr'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'tumblr',
					'label'   => 'Tumblr',
					'default' => 'Tumblr'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'dribbble',
					'label'   => 'Dribbble',
					'default' => 'Dribbble'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'soundcloud',
					'label'   => 'Soundcloud',
					'default' => 'Soundcloud'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'instagram',
					'label'   => 'Instagram',
					'default' => 'Instagram'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'vimeo',
					'label'   => 'Vimeo',
					'default' => 'Vimeo'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'youtube',
					'label'   => 'Youtube',
					'default' => 'Youtube'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'vk',
					'label'   => 'VK',
					'default' => 'VK'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'reddit',
					'label'   => 'Reddit',
					'default' => 'Reddit'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'weibo',
					'label'   => 'Weibo',
					'default' => 'Weibo'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'stumbleupon',
					'label'   => 'StumbleUpon',
					'default' => 'StumbleUpon'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'telegram',
					'label'   => 'Telegram',
					'default' => 'Telegram'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'rss',
					'label'   => 'RSS',
					'default' => 'RSS'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'website',
					'label'   => 'Website',
					'default' => 'Website'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'Account Page',
			'name'   => 'account_page_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'my_account',
					'label'   => 'My Account',
					'default' => 'My Account'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'edit_account',
					'label'   => 'Edit Account',
					'default' => 'Edit Account'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'change_password',
					'label'   => 'Change Password',
					'default' => 'Change Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'my_post',
					'label'   => ' My Post',
					'default' => 'My Post'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'first_name',
					'label'   => 'First Name',
					'default' => 'First Name'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'first_name_desc',
					'label'   => 'Insert your first name',
					'default' => 'Insert your first name'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'last_name',
					'label'   => 'Last Name',
					'default' => 'Last Name'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'last_name_desc',
					'label'   => 'Insert your last name',
					'default' => 'Insert your last name'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'display_name',
					'label'   => 'Display Name',
					'default' => 'Display Name'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'contact_info',
					'label'   => 'Contact Info',
					'default' => 'Contact Info'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'about_yourself',
					'label'   => 'About Yourself',
					'default' => 'About Yourself'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'biographical_info',
					'label'   => 'Biographical Info',
					'default' => 'Biographical Info'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'profile_picture',
					'label'   => 'Profile Picture',
					'default' => 'Profile Picture'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'choose_image',
					'label'   => 'Choose Image Button',
					'default' => 'Choose Image'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'add_media',
					'label'   => 'Add Media Button',
					'default' => 'Add Media'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'insert_media',
					'label'   => 'Insert Media Button',
					'default' => 'Insert Media'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'old_password',
					'label'   => 'Old Password',
					'default' => 'Old Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'new_password',
					'label'   => 'New Password',
					'default' => 'New Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'confirm_password',
					'label'   => 'Confirm Password',
					'default' => 'Confirm Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'edit_account_button',
					'label'   => 'Edit Account Button',
					'default' => 'Edit Account'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'change_password_button',
					'label'   => 'Change Password Button',
					'default' => 'Change Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'first_name_required',
					'label'   => 'First name should not be empty',
					'default' => 'First name should not be empty'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'last_name_required',
					'label'   => 'Last name should not be empty',
					'default' => 'Last name should not be empty'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'success_edit_account',
					'label'   => 'You have successfully edited your account details',
					'default' => 'You have successfully edited your account details'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'old_password_error',
					'label'   => 'Your old password is not valid',
					'default' => 'Your old password is not valid'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'new_password_empty',
					'label'   => 'Please enter your new password',
					'default' => 'Please enter your new password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'confirm_password_error',
					'label'   => 'New Password & Confirm Password do not match',
					'default' => 'New Password & Confirm Password do not match'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'success_change_password',
					'label'   => 'You have successfully changed your password',
					'default' => 'You have successfully changed your password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'old_password_empty',
					'label'   => 'Please enter your old password',
					'default' => 'Please enter your old password'
				)
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'Account Popup',
			'name'   => 'account_popup_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'empty_username',
					'label'   => 'Please enter your username!',
					'default' => 'Please enter your username!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'empty_email',
					'label'   => 'Please enter your email!',
					'default' => 'Please enter your email!',
				),
				array(
					'type'    => 'textbox',
					'name'    => 'empty_password',
					'label'   => 'Please enter your password!',
					'default' => 'Please enter your password!',
				),
				array(
					'type'    => 'textbox',
					'name'    => 'invalid_recaptcha',
					'label'   => 'Invalid Recaptcha!',
					'default' => 'Invalid Recaptcha!',
				),
				array(
					'type'    => 'textbox',
					'name'    => 'welcome_back',
					'label'   => 'Welcome Back!',
					'default' => 'Welcome Back!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_to_account',
					'label'   => 'Login to account',
					'default' => 'Login to your account below'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'username',
					'label'   => 'Username',
					'default' => 'Username'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'username_s',
					'label'   => 'Username: %s',
					'default' => 'Username: %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'password',
					'label'   => 'Password',
					'default' => 'Password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'remember_me',
					'label'   => 'Remember Me',
					'default' => 'Remember Me'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'log_in',
					'label'   => 'Log In',
					'default' => 'Log In'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'processing',
					'label'   => 'Processing',
					'default' => 'Processing . . .'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'forgotten_password',
					'label'   => 'Forgotten Password',
					'default' => 'Forgotten Password?'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'create_new_account',
					'label'   => 'Create New Account',
					'default' => 'Create New Account!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'fill_form_to_register',
					'label'   => 'Fill form to register',
					'default' => 'Fill the forms bellow to register'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'your_email',
					'label'   => 'Your email',
					'default' => 'Your email'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'sign_up',
					'label'   => 'Sign Up',
					'default' => 'Sign Up'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'all_field_required',
					'label'   => 'All fields are required',
					'default' => 'All fields are required.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'retrieve_password',
					'label'   => 'Retrieve your password',
					'default' => 'Retrieve your password'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'enter_detail_reset_password',
					'label'   => 'Enter detail to reset password',
					'default' => 'Please enter your username or email address to reset your password.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'your_email_or_username',
					'label'   => 'Your email or username',
					'default' => 'Your email or username'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'reset_password',
					'label'   => 'Reset Password',
					'default' => 'Reset Password'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'JNews Social Login',
			'name'   => 'social_login_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'login_facebook',
					'label'   => 'Sign In with Facebook',
					'default' => 'Sign In with Facebook'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_google',
					'label'   => 'Sign In with Google',
					'default' => 'Sign In with Google'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_twitter',
					'label'   => 'Sign In with Twitter',
					'default' => 'Sign In with Twitter'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_linkedin',
					'label'   => 'Sign In with Linked In',
					'default' => 'Sign In with Linked In'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_facebook',
					'label'   => 'Sign Up with Facebook',
					'default' => 'Sign Up with Facebook'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_google',
					'label'   => 'Sign Up with Google',
					'default' => 'Sign Up with Google'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_twitter',
					'label'   => 'Sign Up with Twitter',
					'default' => 'Sign Up with Twitter'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_linkedin',
					'label'   => 'Sign Up with Linked In',
					'default' => 'Sign Up with Linked In'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'or',
					'label'   => 'Or',
					'default' => 'OR'
				),
			)
		),


		array(
			'type'   => 'section',
			'title'  => 'Login, Register, Forget Password',
			'name'   => 'login_register_forget_password_section',
			'fields' => array(

				
				array(
					'type'    => 'textbox',
					'name'    => 'username_email_required',
					'label'   => 'Username / email is required',
					'default' => 'Username / email is required'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'password_required',
					'label'   => 'Password is required',
					'default' => 'Password is required'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'user_with_email_not_found',
					'label'   => 'A user could not be found with this email address.',
					'default' => 'A user could not be found with this email address.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_success_wait_redirecting',
					'label'   => 'Login successful. Please wait while you are being redirected.',
					'default' => 'Login successful. Please wait while you are being redirected.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'username_already_taken',
					'label'   => 'Username is already taken',
					'default' => 'Username is already taken'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'invalid_username',
					'label'   => 'Invalid username',
					'default' => 'Invalid username'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'please_enter_username',
					'label'   => 'Please enter a username',
					'default' => 'Please enter a username'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'invalid_email',
					'label'   => 'Invalid email',
					'default' => 'Invalid email'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'email_already_registered',
					'label'   => 'Email is already registered',
					'default' => 'Email is already registered'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_success_check_email',
					'label'   => 'Register successful. Please check your email (index or spam folder), the password was sent there.',
					'default' => 'Register successful. Please check your email (index or spam folder), the password was sent there.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'enter_username_email_address',
					'label'   => 'enter a username or e-mail address',
					'default' => 'enter a username or e-mail address'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'email_username_not_registered',
					'label'   => 'email or username is not registered into this site',
					'default' => 'email or username is not registered into this site'
				),

				array(
					'type'    => 'textbox',
					'name'    => 'email_not_sent_host_disable_mail_function',
					'label'   => 'The e-mail could not be sent. Your host may have disabled the mail() function...',
					'default' => 'The e-mail could not be sent. Your host may have disabled the mail() function...'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'check_email_confirmation_link',
					'label'   => 'Please check your e-mail for the confirmation link',
					'default' => 'Please check your e-mail for the confirmation link'
				),

			)
		),


		array(
			'type'   => 'section',
			'title'  => 'Email Message',
			'name'   => 'email_message_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 's_password_reset',
					'label'   => 'Password Reset Title',
					'default' => '[%s] Password Reset'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'someone_request_password_reset',
					'label'   => 'Someone has requested a password reset for the following account:',
					'default' => 'Someone has requested a password reset for the following account:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'ignore_mistake_email',
					'label'   => 'If this was a mistake, just ignore this email and nothing will happen.',
					'default' => 'If this was a mistake, just ignore this email and nothing will happen.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'reset_password_visit_address',
					'label'   => 'To reset your password, visit the following address:',
					'default' => 'To reset your password, visit the following address:'
				),
			)
		),

		array(
			'type'   => 'section',
			'title'  => 'JNews Video',
			'name'   => 'video_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'my_channel',
					'label'   => 'My Channel',
					'default' => 'My Channel'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'video_watch_later',
					'label'   => 'Watch Later',
					'default' => 'Watch Later'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'jnews_video_subscribe_button',
					'label'   => 'Subscribe Button Text',
					'default' => 'Subscribe'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'unsubscribe_button',
					'label'   => 'Unsubscribe Button Text',
					'default' => 'Unsubscribe'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_bp_tab_title',
					'label'   => 'Playlist Text BuddyPress Navigation',
					'default' => 'Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'home_bp_tab_title',
					'label'   => 'Home Text BuddyPress Navigation',
					'default' => 'Home'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_type_public',
					'label'   => 'Public Text BuddyPress Navigation',
					'default' => 'Public'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_type_private',
					'label'   => 'Private Text BuddyPress Navigation',
					'default' => 'Private'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'video_must_login',
					'label'   => 'You must login to do this thing!',
					'default' => 'You must login to do this thing!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'provider_not_supported',
					'label'   => 'Provider is not supported',
					'default' => 'Provider is not supported'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'internal_server_error',
					'label'   => 'Internal Server Error!',
					'default' => 'Internal Server Error!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'favorite',
					'label'   => 'Favorite Page Title',
					'default' => 'Favorite'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'watch_later',
					'label'   => 'Watch Later Page Title',
					'default' => 'Watch Later'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'add_to_playlist',
					'label'   => 'Add to playlist',
					'default' => 'Add to playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'add_new_playlist',
					'label'   => 'Add New Playlist',
					'default' => 'Add New Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'new_playlist',
					'label'   => 'New Playlist',
					'default' => 'New Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'share_video',
					'label'   => 'Share',
					'default' => 'Share'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'select_visibility',
					'label'   => 'Select Visibility',
					'default' => 'Select Visibility'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'video_favorite',
					'label'   => 'Favorite Video',
					'default' => 'Favorite Video'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'views_post_header',
					'label'   => 'Views',
					'default' => 'Views'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'prev_block_video',
					'label'   => 'Prev',
					'default' => 'Prev'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'next_block_video',
					'label'   => 'Next',
					'default' => 'Next'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'previous_block_video',
					'label'   => 'Previous',
					'default' => 'Previous'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'show_more',
					'label'   => 'Show More',
					'default' => 'Show More'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'loading_video',
					'label'   => 'Loading...',
					'default' => 'Loading...'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'videos',
					'label'   => 'Videos',
					'default' => 'Videos'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_not_found',
					'label'   => 'Playlist not found!',
					'default' => 'Playlist not found!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_id_not_set',
					'label'   => 'Playlist ID not set!',
					'default' => 'Playlist ID not set!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_name_cannot_be_empty',
					'label'   => 'Playlist name cannot be empty',
					'default' => 'Playlist name cannot be empty'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_has_been_created',
					'label'   => 'Your playlist has been created',
					'default' => 'Your playlist has been created'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'failed_delete_playlist_posts',
					'label'   => 'Could not delete playlist posts!',
					'default' => 'Could not delete playlist posts!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'added_to_default_playlist',
					'label'   => 'Added to %s',
					'default' => 'Added to %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'added_to_playlist',
					'label'   => 'Added to playlist %s',
					'default' => 'Added to playlist %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'removed_from_playlist',
					'label'   => 'Removed from playlist %s',
					'default' => 'Removed from playlist %s'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'post_id_not_set',
					'label'   => 'Post ID not set!',
					'default' => 'Post ID not set!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'user_is_not_the_owner',
					'label'   => 'User %s is not the owner!',
					'default' => 'User %s is not the owner!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'post_not_exists',
					'label'   => 'Post not exists!',
					'default' => 'Post not exists!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'post_type_not_allowed',
					'label'   => 'Post type not allowed!',
					'default' => 'Post type not allowed!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'failed_insert_into_playlist',
					'label'   => 'Could not insert into the playlist!',
					'default' => 'Could not insert into the playlist!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_id_not_found',
					'label'   => 'Playlist with id %s not found!',
					'default' => 'Playlist with id %s not found!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'failed_delete_playlist_post',
					'label'   => 'Could not delete playlist post!',
					'default' => 'Could not delete playlist post!'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_updated_successfully',
					'label'   => 'Playlist updated successfully',
					'default' => 'Playlist updated successfully'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_deleted',
					'label'   => 'Playlist deleted',
					'default' => 'Playlist deleted'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist',
					'label'   => 'Playlist',
					'default' => 'Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'category_text',
					'label'   => 'Category:',
					'default' => 'Category:'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'private_playlist',
					'label'   => 'Private Playlist',
					'default' => 'Private Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'public_playlist',
					'label'   => 'Public Playlist',
					'default' => 'Public Playlist'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'edit',
					'label'   => 'Edit',
					'default' => 'Edit'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'delete',
					'label'   => 'Delete',
					'default' => 'Delete'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'added',
					'label'   => 'Added',
					'default' => 'Added'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'list_videos',
					'label'   => 'List Videos',
					'default' => 'List Videos'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'subscriber_video',
					'label'   => 'Subscriber',
					'default' => 'Subscriber'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'playlist_is_empty',
					'label'   => '%s is empty',
					'default' => '%s is empty'
				),
				/** Temporary disabled ( using custom navigation in customizer ) */
				//			    array(
				//				    'type'    => 'textbox',
				//				    'name'    => 'jnews_playlist_bp_component_title',
				//				    'label'   => 'JNews playlist',
				//				    'default' => 'JNews playlist'
				//			    ),
				//			    array(
				//				    'type'    => 'textbox',
				//				    'name'    => 'jnews_playlist_bp_component_description',
				//				    'label'   => 'Allow your users to manage their playlist directly from within their profiles.',
				//				    'default' => 'Allow your users to manage their playlist directly from within their profiles.'
				//			    ),
			)
		),

		array(
			'type'   => 'section',
			'title'  => 'JNews Paywall',
			'name'   => 'paywall_section',
			'fields' => array(
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_subscription_description',
					'label'   => 'Paywall Truncate Subscribe Description',
					'default' => 'Gain access to all our Premium contents. <br/><strong>More than 100+ articles.</strong>'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_unlock_description',
					'label'   => 'Paywall Truncate Unlock Description',
					'default' => 'Unlock this article and gain permanent access to read it.'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'my_subscription',
					'label'   => 'Subscription',
					'default' => 'Subscription'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'unlocked_posts',
					'label'   => 'Unlocked Posts',
					'default' => 'Unlocked Posts'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'no_content_available',
					'label'   => 'No Content Available',
					'default' => 'No Content Available'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_day',
					'label'   => 'Days Text',
					'default' => 'Days'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_week',
					'label'   => 'Week Text',
					'default' => 'Weeks'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_month',
					'label'   => 'Month Text',
					'default' => 'Months'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_year',
					'label'   => 'Year Text',
					'default' => 'Years'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_header_title',
					'label'   => 'Support authors and subscribe to content',
					'default' => 'Support authors and subscribe to content',
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_header_description',
					'label'   => 'This is premium stuff. Subscribe to read the entire article.',
					'default' => 'This is premium stuff. Subscribe to read the entire article.',
				),
				array(
					'type'    => 'textbox',
					'name'    => 'subscribe_title',
					'label'   => 'Subscribe Title at Truncated Article',
					'default' => 'Subscribe'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_subscribe_button',
					'label'   => 'Subscribe Button at Truncated Article',
					'default' => 'Subscribe Now'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'unlock_title',
					'label'   => 'Unlock Title at Truncated Article',
					'default' => 'Buy Article'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'unlock_button',
					'label'   => 'Unlock Button at Truncated Article',
					'default' => 'Unlock Now'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'paywall_logintext',
					'label'   => 'Login if you have purchased',
					'default' => '<a href="%s">Login</a> if you have purchased'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'login_to_purchase',
					'label'   => 'Login to purchase',
					'default' => 'Login to purchase or access your purchased package'
				),
				array(
					'type'    => 'textbox',
					'name'    => 'register_to_purchase',
					'label'   => 'Register to purchase',
					'default' => 'Register to purchase or access your purchased package'
				),
			)
		),
	)
);


