<?php
/**
 * @author Jegtheme
 */

namespace JNews\WEBSTORIES;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Helper
 */
class Helper {

	public static function jnews_webstories_get_category_option( $value = null ) {
		if ( ! defined( 'WEBSTORIES_VERSION' ) ) {
			return array();
		}
		$result = array();
		$count  = self::jnews_webstories_category_tax( array( 'field' => 'count' ) );

		if ( (int) $count <= jnews_load_resource_limit() ) {
			$terms = self::jnews_webstories_category_tax( array( 'hide_empty' => 0 ) );
			foreach ( $terms as $term ) {
				$result[] = array(
					'value' => $term->term_id,
					'text'  => $term->name,
				);
			}
		} else {
			$selected = $value;

			if ( ! empty( $selected ) ) {
				$terms = self::jnews_webstories_category_tax(
					array(
						'hide_empty'   => false,
						'hierarchical' => true,
						'include'      => $selected,
					)
				);

				foreach ( $terms as $term ) {
					$result[] = array(
						'value' => $term->term_id,
						'text'  => $term->name,
					);
				}
			}
		}

		return $result;
	}

	public static function jnews_webstories_get_tag_option( $value = null ) {
		if ( ! defined( 'WEBSTORIES_VERSION' ) ) {
			return array();
		}

		$result = array();
		$count  = self::jnews_webstories_tag_tax( array( 'field' => 'count' ) );

		if ( (int) $count <= jnews_load_resource_limit() ) {
			$terms = self::jnews_webstories_tag_tax( array( 'hide_empty' => 0 ) );
			foreach ( $terms as $term ) {
				$result[] = array(
					'value' => $term->term_id,
					'text'  => $term->name,
				);
			}
		} else {
			$selected = $value;

			if ( ! empty( $selected ) ) {
				$terms = self::jnews_webstories_tag_tax(
					array(
						'hide_empty'   => false,
						'hierarchical' => true,
						'include'      => $selected,
					)
				);

				foreach ( $terms as $term ) {
					$result[] = array(
						'value' => $term->term_id,
						'text'  => $term->name,
					);
				}
			}
		}

		return $result;
	}

	public static function jnews_webstories_cache( $query_hash, $value = false ) {
		if ( ! $value ) {
			return wp_cache_get( $query_hash, 'jnews-webstories' );
		}
		wp_cache_set( $query_hash, $value, 'jnews-webstories' );

		return $value;
	}

	public static function jnews_webstories_category_tax( $args = '' ) {
		$slug       = 'web_story_category';
		$defaults   = array( 'taxonomy' => $slug );
		$args       = wp_parse_args( $args, $defaults );
		$query_hash = 'query_hash_' . md5( serialize( $args ) );
		if ( ! $webstories_categories = self::jnews_webstories_cache( $query_hash ) ) {
			$webstories_categories = self::jnews_webstories_cache(
				$query_hash,
				call_user_func(
					static function () use ( $args ) {
						return get_terms( $args );
					}
				)
			);
		}

		if ( empty( $webstories_categories ) ) {
			return array();
		}

		/**
		 * Filters the array of term objects returned for the 'post_tag' taxonomy.
		 *
		 * @param WP_Term[]|int $tags Array of 'post_tag' term objects, or a count thereof.
		 * @param array $args An array of arguments. @see get_terms()
		 *
		 * @since 7.5.0
		 */
		$webstories_categories = apply_filters( 'jnews_get_webstories_category_tax', $webstories_categories, $args );
		return $webstories_categories;
	}

	public static function jnews_webstories_tag_tax( $args ) {
		$slug       = 'web_story_tag';
		$defaults   = array( 'taxonomy' => $slug );
		$args       = wp_parse_args( $args, $defaults );
		$query_hash = 'query_hash_' . md5( serialize( $args ) );
		if ( ! $webstories_tags = self::jnews_webstories_cache( $query_hash ) ) {
			$webstories_tags = self::jnews_webstories_cache(
				$query_hash,
				call_user_func(
					static function () use ( $args ) {
						return get_terms( $args );
					}
				)
			);
		}

		if ( empty( $webstories_tags ) ) {
			return array();
		}

		/**
		 * Filters the array of term objects returned for the 'post_tag' taxonomy.
		 *
		 * @param WP_Term[]|int $tags Array of 'post_tag' term objects, or a count thereof.
		 * @param array $args An array of arguments. @see get_terms()
		 *
		 * @since 7.5.0
		 */
		$webstories_tags = apply_filters( 'jnews_get_webstories_tag_tax', $webstories_tags, $args );
		return $webstories_tags;
	}

	public static function jnews_webstories_get_category() {
		if ( isset( $_REQUEST['nonce'], $_REQUEST['query'] ) && wp_verify_nonce( sanitize_key( $_REQUEST['nonce'] ), 'jeg_find_category' ) ) {
			$value = sanitize_text_field( wp_unslash( $_REQUEST['query'] ) );
			wp_send_json_success( self::jnews_webstories_get_category_option( $value ) );
		}
	}

	public static function jnews_webstories_get_tag() {
		if ( isset( $_REQUEST['nonce'], $_REQUEST['value'] ) && wp_verify_nonce( sanitize_key( $_REQUEST['nonce'] ), 'jeg_find_tag' ) ) {
			$value = sanitize_text_field( wp_unslash( $_REQUEST['query'] ) );
			wp_send_json_success( self::jnews_webstories_get_tag_option( $value ) );
		}
	}

	public static function jnews_default_webstories_query( $args, $attr ) {
		if ( 'post' !== $args['post_type'] ) {
			unset( $args['category__in'] );
			unset( $args['category__not_in'] );
			unset( $args['tag__in'] );
			unset( $args['tag__not_in'] );
		}

		if ( isset( $args['web_story_category__in'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'web_story_category',
					'field'    => 'term_id',
					'terms'    => $args['web_story_category__in'],
					'operator' => 'NOT EXISTS',
				),
			);
		}

		if ( isset( $args['web_story_category__not_in'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'web_story_category',
					'field'    => 'term_id',
					'terms'    => $args['web_story_category__not_in'],
					'operator' => 'NOT IN',
				),
			);
		}

		if ( isset( $args['web_story_tag__in'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'web_story_tag',
					'field'    => 'term_id',
					'terms'    => 'tagu',
					'operator' => 'IN',
				),
			);
		}

		if ( isset( $args['web_story_tag__not_in'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'web_story_tag',
					'field'    => 'term_id',
					'terms'    => $args['web_story_tag__not_in'],
					'operator' => 'NOT IN',
				),
			);
		}

		return $args;
	}
}
