(function($){

    "use strict";

    $.fn.ene_carousel = function () {
        $(this).each(function () {

            if(!$(this).hasClass('slick-carousel')) return;

            var id = $(this).data('id');
            var param = window[id];

            $(this).slick({
                dots: true,
                infinite: false,
                speed: 300,
                arrows: false,
                slidesToShow: 1,
                adaptiveHeight: true,
                slidesToShow: param.desktop,
                slidesToScroll: param.desktop,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: param.tab,
                            slidesToScroll: param.tab
                        }
                    },
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: param.landscape,
                            slidesToScroll: param.landscape
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: param.phone,
                            slidesToScroll: param.phone
                        }
                    }
                ]
            });
        });
    };

    /* Feature */
    var activate_filter = function(element)
    {
        $(element).siblings().removeClass("active");
        $(element).addClass("active");
    };

    var filter_content = function(grid, filter)
    {
        grid.isotope({
            filter : filter
        });
    };


    /** Feature Grid **/

    $(".feature-grid").isotope({
        itemSelector: ".grid-item"
    });

    $(".feature-filter a").bind("click", function(e){
        e.preventDefault();
        var element = this;
        var root = $($(this).parents('.feature-filter').get(0)).data('filter');
        var content = $("[data-content='" + root + "']");

        activate_filter($(element).parent());
        filter_content(content, $(element).data("filter"));
    });


    /**
     * Video Popup
     */

    $(".video-popup").bind("click", function(e){
        e.preventDefault();

        var youtube_url = $(this).data("url");

        $.magnificPopup.open({
            items: {
                src: youtube_url
            },
            type: 'iframe',
            iframe: {
                markup: '<div class="mfp-iframe-scaler">'+
                '<div class="mfp-close"></div>'+
                '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
                '</div>',
                patterns: {
                    youtube: {
                        index: 'youtube.com/',
                        id: 'v=',
                        src: '//www.youtube.com/embed/%id%?autoplay=1'
                    }
                },
                srcAction: 'iframe_src',
            }
        });
    });

    /** demo grid **/

    $('.demo-grid .owl-carousel').owlCarousel({
        items : 1,
        dots: true,
        navText: false,
        nav: true,
        lazyLoad:true,
    });

    var $demo = $(".demo-grid").isotope({
        itemSelector: ".grid-item",
        layoutMode: "fitRows",
    });

    $(".demo-grid").imagesLoaded().progress( function() {
        $demo.isotope('layout');
    });

    $(".demo-filter a").bind("click", function(e){
        e.preventDefault();
        var element = this;
        var root = $($(this).parents('.demo-filter').get(0)).data('filter');
        var content = $("[data-content='" + root + "']");

        activate_filter($(element).parent());
        filter_content(content, $(element).data("filter"));
    });


    /** dispatch **/
    function dispatch()
    {
        // testimonial
        $('.slick-carousel').ene_carousel();
    }

    $(document).ready(function()
    {
        dispatch();
    });

})(jQuery);