<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Feature_Filter extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_feature_filter';
    }

    public function get_title()
    {
        return "Feature Filter Demo";
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_feature_filter',
            [
                'label' => 'Feature Filter',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => 'Feature Category',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'slug',
            [
                'label' => 'Feature Slug',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $this->add_control(
            'filter_item',
            [
                'label' => 'Feature Filter Item',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '<i class="{{ title }}"></i> {{{ title }}}',
            ]
        );

        $this->add_control(
            'filter_id',
            [
                'label'         => 'Feature Filter ID',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $html = "<li class='active'><a href='#' data-filter='*'>All</a></li>";

        foreach($settings['filter_item'] as $filter) {
            $html .= "<li class=''><a href='#' data-filter='.{$filter['slug']}'>{$filter['title']}</a></li>";
        }


        echo "<ul class=\"d-flex justify-content-center align-items-center mx-auto no-list feature-filter\" data-filter='{$settings['filter_id']}'>{$html}</ul>";
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}