<?php
/*
	Plugin Name: JNews - Elementor Demo Element
	Plugin URI: http://jegtheme.com/
	Description: Demo Plugin for JNews
	Version: 1.0.0
	Author: Jegtheme
	Author URI: http://jegtheme.com
	License: GPL2
*/

defined( 'JNEWS_DEMO_ELEMENTOR' )          or define( 'JNEWS_DEMO_ELEMENTOR', 'jnews-demo-elementor');
defined( 'JNEWS_DEMO_ELEMENTOR_URL' )      or define( 'JNEWS_DEMO_ELEMENTOR_URL', plugins_url('jnews-demo-elementor') );
defined( 'JNEWS_DEMO_ELEMENTOR_FILE' )     or define( 'JNEWS_DEMO_ELEMENTOR_FILE',  __FILE__ );
defined( 'JNEWS_DEMO_ELEMENTOR_DIR' )      or define( 'JNEWS_DEMO_ELEMENTOR_DIR', plugin_dir_path( __FILE__ ) );


add_action( 'elementor/widgets/widgets_registered', 'jde_register_elementor_module');

/**
 * @param \Elementor\Widgets_Manager $widgets_manager
 */
function jde_register_elementor_module($widgets_manager)
{
    include "elementor/testimonial.php";
    $widgets_manager->register_widget_type( new JEG_Testimonial() );

    include "elementor/feature-filter.php";
    $widgets_manager->register_widget_type( new JEG_Feature_Filter() );

    include "elementor/feature-content.php";
    $widgets_manager->register_widget_type( new JEG_Feature_Content() );

    include "elementor/demo-filter.php";
    $widgets_manager->register_widget_type( new JEG_Demo_Filter() );

    include "elementor/demo-content.php";
    $widgets_manager->register_widget_type( new JEG_Demo_Content() );

    include "elementor/video-popup.php";
    $widgets_manager->register_widget_type( new JEG_Video_Popup() );
}


add_action( 'wp_print_styles', 'jde_load_assets' );

function jde_load_assets()
{
    wp_enqueue_style( 'slick', JNEWS_DEMO_ELEMENTOR_URL . '/slick/slick.css', null, null, 'all' );
    wp_enqueue_style( 'slick-theme', JNEWS_DEMO_ELEMENTOR_URL . '/slick/slick-theme.css', null, null, 'all' );
    wp_enqueue_style( 'flat-icon', JNEWS_DEMO_ELEMENTOR_URL . '/flaticon/flaticon.css', null, null, 'all' );
    wp_enqueue_style( 'landing', JNEWS_DEMO_ELEMENTOR_URL . '/assets/css/landing.css', null, null, 'all' );

    wp_enqueue_script( 'slick', JNEWS_DEMO_ELEMENTOR_URL . '/slick/slick.js', array('jquery'), null);
    wp_enqueue_script( 'jde-demo', JNEWS_DEMO_ELEMENTOR_URL . '/assets/js/plugin.js', null, null, true );
}