<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Demo_Content extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_demo_content';
    }

    public function get_title()
    {
        return "Demo Content Demo";
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_demo_content',
            [
                'label' => 'Demo Content',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => 'Demo Title',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'category',
            [
                'label' => 'Demo Category',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'ribbon_type',
            [
                'label' => 'Ribbon Type',
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'none' => __( 'None', 'jnews-demo-elementor' ),
                    'hot' => __( 'Hot', 'jnews-demo-elementor' ),
                    'new' => __( 'New', 'jnews-demo-elementor' ),
                ],
                'label_block' => true,
                'default' => 'none',
            ]
        );



        for($i = 1; $i <= 6; $i++)
        {
            $repeater->add_control(
                "image$i",
                [
                    'label' => "Demo $i Image",
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'default' => [],
                ]
            );

            $repeater->add_control(
                "link$i",
                [
                    'label' => "Demo $i URL",
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => [],
                ]
            );
        }


        $this->add_control(
            'filter_item',
            [
                'label' => 'Demo Item',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '<i class="{{ title }}"></i> {{{ title }}}',
            ]
        );

        $this->add_control(
            'show_submit_button',
            [
                'label'         => 'Show Submit Button',
                'description'   => 'Display demo placholder and submit demo request button.',
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __( 'Show', 'your-plugin' ),
                'label_off'     => __( 'Hide', 'your-plugin' ),
                'return_value'  => 'yes',
                'default'       => 'yes',
            ]
        );

        $this->add_control(
            'filter_id',
            [
                'label'         => 'Demo Filter ID',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $html = '';

        foreach($settings['filter_item'] as $demo)
        {
            $carousel = '';
            $ribbon = !empty($demo['ribbon_type']) && $demo['ribbon_type'] != 'none' ? "<div class=\"ribbon {$demo['ribbon_type']}\">{$demo['ribbon_type']}</div>" : '';

            for($i = 1; $i <= 6; $i++)
            {
                if($demo["image{$i}"]['url'] !== '') {
                    $carousel .=
                        '<div class="owl-item">
                            <a href="' . $demo["link{$i}"] . '" target="_blank">
                                <img class="owl-lazy" data-src="' . $demo["image{$i}"]['url'] . '"/>
                            </a>
                        </div>';
                }
            }

            $html .=
                '<div class="grid-item ' . $demo['category'] .'">
                    '. $ribbon .'
                    <div class="grid-image loading">
                        <div class="owl-carousel owl-theme">
                            ' . $carousel . '
                        </div>
                    </div>
                    <div class="grid-title">
                        <h3>
                            <a href="' . $demo['link1'] . '">' . $demo['title'] . '</a>
                        </h3>
                    </div>
                </div>';
        }

        if (!empty($settings['show_submit_button']) && $settings['show_submit_button'] == 'yes') {
            $html .= "
              <div class=\"grid-item #\">
                  <a class=\"grid-link\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfHEypFc-tY8BzGdEQU9ECf3bld_Een7_bSStoo8ICR8UG0eA/viewform?entry.1558582620&amp;entry.1060472253&amp;entry.1295994925\" target=\"_blank\" style=\"text-decoration: none;\">
                      <div class=\"grid-submit\">
                          <div class=\"grid-submit-wrapper\">
                            <i class=\"fa  fa-cloud-upload\"></i>
                          </div>
                      </div>
                      <div class=\"grid-title\">
                          <h3>Submit Demo Request</h3>
                      </div>
                  </a>
              </div>";
        }

        echo "<div class='grid demo-grid' data-content='{$settings['filter_id']}'>{$html}</div>";
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}