<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Demo_Filter extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_demo_filter';
    }

    public function get_title()
    {
        return "Demo Filter Demo";
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_demo_filter',
            [
                'label' => 'Demo Filter',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => 'Demo Category',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'slug',
            [
                'label' => 'Demo Slug',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $this->add_control(
            'demo_item',
            [
                'label' => 'Demo Filter Item',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '<i class="{{ title }}"></i> {{{ title }}}',
            ]
        );

        $this->add_control(
            'demo_id',
            [
                'label'         => 'Demo Filter ID',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $html = "<li class='active'><a href='#' data-filter='*'>All</a></li>";

        foreach($settings['demo_item'] as $filter) {
            $html .= "<li class=''><a href='#' data-filter='.{$filter['slug']}'>{$filter['title']}</a></li>";
        }

        echo "<ul class=\"d-flex justify-content-center align-items-center mx-auto no-list demo-filter\" data-filter='{$settings['demo_id']}'>{$html}</ul>";
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}