<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Feature_Content extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_feature_content';
    }

    public function get_title()
    {
        return "Feature Content Demo";
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_feature_content',
            [
                'label' => 'Feature Content',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => 'Feature Title',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'category',
            [
                'label' => 'Feature Category',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label' => 'Feature Content',
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => 'Feature Icon',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $this->add_control(
            'filter_item',
            [
                'label' => 'Feature Item',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '<i class="{{ title }}"></i> {{{ title }}}',
            ]
        );

        $this->add_control(
            'filter_id',
            [
                'label'         => 'Feature Filter ID',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $html = '';

        foreach($settings['filter_item'] as $filter) {
            $html .=
                '<div class="grid-item ' . $filter['category'] . '">
                    <div class="grid-feature">
                        <div class="grid-icon">
                            <i class="' . $filter['icon'] . '"></i>
                        </div>
                        <div class="grid-title">
                            <h3>' . $filter['title'] . '</h3>
                            <p>' . $filter['content'] . '</p>
                        </div>
                    </div>
                </div>';
        }

        echo "<div class='grid feature-grid' data-content='{$settings['filter_id']}'>{$html}</div>";
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}