<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Testimonial extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_testimonial';
    }

    public function get_title()
    {
        return "Testimonial Demo";
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_testimonial_item',
            [
                'label' => 'Testimonial Item',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Testimonial Title', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label' => __( 'Testimonial Content', 'elementor' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __( 'Testimonial Name', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label' => __( 'Testimonial Position', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => [],
            ]
        );



        $this->add_control(
            'testimonial_item',
            [
                'label' => __( 'Testimonial Item', 'elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '<i class="{{ title }}"></i> {{{ title }}}',
            ]
        );

        $this->add_control(
            'number_desktop',
            [
                'label'         => 'Number of item on Desktop',
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size' => 3,
                ],
                'range'         => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 6,
                        'step' => 1,
                    ],
                ],
            ]
        );


        $this->add_control(
            'number_tab',
            [
                'label'         => 'Number of item on Tab',
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size' => 2,
                ],
                'range'         => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 6,
                        'step' => 1,
                    ],
                ],
            ]
        );

        $this->add_control(
            'number_phone_landscape',
            [
                'label'         => 'Number of item on Phone Landscape',
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size' => 1,
                ],
                'range'         => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 6,
                        'step' => 1,
                    ],
                ],
            ]
        );

        $this->add_control(
            'number_phone',
            [
                'label'         => 'Number of item on Phone',
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size' => 1,
                ],
                'range'         => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 6,
                        'step' => 1,
                    ],
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings();
        $items = array();

        foreach($settings['testimonial_item'] as $item) {
            $items[] =
                "<div class='epic-testimonial-item'>                    
                    <h4 class='testimonial-title'>
                        {$item['title']}
                    </h4>
                    <div class=\"review-stars\">
                        <i class=\"fa fa-star\"></i>
                        <i class=\"fa fa-star\"></i>
                        <i class=\"fa fa-star\"></i>
                        <i class=\"fa fa-star\"></i>
                        <i class=\"fa fa-star\"></i>
                    </div>
                    <div class=\"testimonial-text\">
                        {$item['content']}
                    </div>
                    <div class=\"testimonial-user\">
                        <strong>{$item['name']}</strong>
                        <span>{$item['position']}</span>
                    </div>
                </div>";
        }

        $unique_id = uniqid('slider_');

        $html =
            "<div class='epic-carousel slick-carousel testimonial-slider' data-id='$unique_id'>" .
            implode("\n", $items) .
            "</div>
            <script>
                var {$unique_id} = {
                    desktop: {$settings['number_desktop']['size']},
                    tab: {$settings['number_tab']['size']},
                    landscape: {$settings['number_phone_landscape']['size']},
                    phone: {$settings['number_phone']['size']},
                };
            </script>";
        echo $html;
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}