<?php

use Elementor\Repeater;
use Elementor\Controls_Manager;

class JEG_Video_Popup extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'jeg_video_popup';
    }

    public function get_title()
    {
        return "Video Popup Demo";
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_video_popup',
            [
                'label' => 'Video Popup',
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label'         => 'Video URL',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->add_control(
            'video_text',
            [
                'label'         => 'Video Text',
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();

        echo
            "<a href=\"#\" class=\"video-popup justify-content-center\" data-url=\"{$settings['video_url']}\">
                <i class=\"flaticon-play\"></i> 
                <span>{$settings['video_text']}</span>
            </a>";
    }

    public function is_reload_preview_required()
    {
        return true;
    }
}